/*
 *  kexbases\ntdll\_ntdll_stubs.c
 *
 *  Copyright (C) 2009, Xeno86
 *  Copyright (C) 2016-2019, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"

#define ERROR_NI             120L
#define HRESULT_NI    0x80004001L
#define STATUS_NI     0xC0000002L

   sUNIMPL_FUNC(CsrGetProcessId, 0);
 rs_UNIMPL_FUNC(NtOpenFile,                 0, 6); //z6 ;needs code to call NtCreateFile
 rs_UNIMPL_FUNC(NtQueryInformationProcess, STATUS_NI, 5); //t5 ;internally static linked!
 rs_UNIMPL_FUNC(NtQueryInformationThread,  STATUS_NI, 5); //t5
 rs_UNIMPL_FUNC(NtQuerySystemInformation,  STATUS_NI, 4); //t4
 rs_UNIMPL_FUNC(NtSetInformationProcess,   STATUS_NI, 4); //z4 ;r0xC0000002s4e120 ;kdw psapi.dll ;
//s_UNIMPL~FUNC(RtlCaptureStackBackTrace,      4); //z4 here and kernel32
/* rs_UNIMPL_FUNC(vDbgPrintExWithPrefix,     -1, 5); //t5 ;ReactOS 2014-06-11 */

 rs_UNIMPL_FUNC(NtDeviceIoControlFile,  STATUS_NI, 10); //t10 ;iphlpapi.5.1.2600.5513
 se_UNIMPL_FUNC(RtlAddAccessAllowedAceEx,          5, ERROR_NI); //z5e ;ROS15 advapi32
 se_UNIMPL_FUNC(RtlAddAccessDeniedAceEx,           5, ERROR_NI); //z5e ;ROS15 advapi32
 rs_UNIMPL_FUNC(RtlCharToInteger,       STATUS_NI, 3); // ** ;ie8
  s_UNIMPL_FUNC(RtlCompareMemory,                  3); //=z3?
 se_UNIMPL_FUNC(RtlDeleteResource,                 1, ERROR_NI); //z1e ;iphlpapi.5.1.2600.5513
 se_UNIMPL_FUNC(RtlInitializeResource,             1, ERROR_NI); //z1e ;iphlpapi.5.1.2600.5513

 rs_UNIMPL_FUNC(LdrLoadDll,        STATUS_NI, 4); // ie8?
 rs_UNIMPL_FUNC(LdrUnloadDll,      STATUS_NI, 1); // ie8?

 rs_UNIMPL_FUNC(NtQueryAttributesFile,  STATUS_NI,   2);  //apphelp5.2
 rs_UNIMPL_FUNC(NtQueryDirectoryFile,   STATUS_NI,  11);  //#LTA Data strarc.exe
 rs_UNIMPL_FUNC(NtQueryInformationFile, STATUS_NI,   5);  //#LTA Data strarc.exe

 rs_UNIMPL_FUNC(NtAcceptConnectPort,    STATUS_NI,   6);
 rs_UNIMPL_FUNC(NtCompleteConnectPort,  STATUS_NI,   1);
 rs_UNIMPL_FUNC(NtConnectPort,          STATUS_NI,   8);
 rs_UNIMPL_FUNC(NtCreatePort,           STATUS_NI,   5);
 rs_UNIMPL_FUNC(NtListenPort,           STATUS_NI,   2);

 rs_UNIMPL_FUNC(NtCreateEvent,          STATUS_NI,   5);
 rs_UNIMPL_FUNC(NtCreateIoCompletion,   STATUS_NI,   4);
 rs_UNIMPL_FUNC(NtCreateKey,            STATUS_NI,   7);
 rs_UNIMPL_FUNC(NtCreateNamedPipeFile,  STATUS_NI,   14);
 rs_UNIMPL_FUNC(NtCreateSection,        STATUS_NI,   7);

#if 0  /* more TBD and FIXME's */
// Unicode APIs
//RtlCopyUnicodeString=** #LTA Data strarc.exe
//RtlCreateUnicodeString=z2 ;>bwc20a\Ntdll: #ROS15 ws2_32 advapi32
//RtlCreateUnicodeStringFromAsciiz=z2 ;fail
//RtlDuplicateUnicodeString=** ;apphelp5.2
//RtlFreeUnicodeString=z1 ;leak, after RtlAnsiStringToUnicodeString, 
//RtlUnicodeStringToInteger=** ;apphelp5.2
//RtlUnicodeStringToOemString=** ;iphlpapi.5.1.2600.5513
//RtlUnicodeToMultiByteSize=
//RtlUnicodeToOemN=** #166
//RtlUpcaseUnicodeChar=** ;apphelp5.2
//RtlUpcaseUnicodeString=** ;apphelp5.2
RtlUpcaseUnicodeToMultiByteN=** ;apphelp5.2
//RtlxAnsiStringToUnicodeSize=** ;apphelp5.2
#endif

  s_UNIMPL_FUNC(RtlAcquireResourceExclusive,      2); //=f2 ;iphlpapi.5.1.2600.5513
 rs_UNIMPL_FUNC(RtlAcquireResourceShared,      1, 2); //=t2 ;iphlpapi.5.1.2600.5513
  s_UNIMPL_FUNC(RtlReleaseResource,               1); //=v1 ;iphlpapi.5.1.2600.5513
 rs_UNIMPL_FUNC(RtlpEnsureBufferSize,  STATUS_NI, 3); //=n3 ;apphelp5.2

/* rs_UNIMPL_FUNC(DbgPrintEx,                     STATUS_NI, 0); //=n80 */
 rs_UNIMPL_FUNC(LdrAccessResource,              STATUS_NI, 4); //=n4 ;ie8
 rs_UNIMPL_FUNC(LdrFindResource_U,              STATUS_NI, 4); //=n4 ;ie8
/* rs_UNIMPL_FUNC(NtQuerySystemTime,              STATUS_NI, 1); //=n1 */
 rs_UNIMPL_FUNC(RtlAppendUnicodeStringToString, STATUS_NI, 2); //=n2
 rs_UNIMPL_FUNC(RtlAppendUnicodeToString,       STATUS_NI, 2); //=n2
 rs_UNIMPL_FUNC(RtlConvertSidToUnicodeString,   STATUS_NI, 3); //=n3 ;qz115 qz166 ie8_wininet
 rs_UNIMPL_FUNC(RtlGetNtProductType,            STATUS_NI, 1); //=n1
 rs_UNIMPL_FUNC(RtlGUIDFromString,              STATUS_NI, 2); //=n2
 rs_UNIMPL_FUNC(RtlIpv4StringToAddressW,        STATUS_NI, 4); //=n4
//rs_UNIMPL~FUNC(RtlUnicodeToMultiByteSize,      STATUS_NI, 3); //=n3
 rs_UNIMPL_FUNC(RtlUpcaseUnicodeToMultiByteN,   STATUS_NI, 5); //=n5 ;apphelp5.2

  s_UNIMPL_FUNC(RtlAssert,                          4); //=v4
/*s_UNIMPL_FUNC(RtlCreateUnicodeString,             2); //=f2 new */
/*s_UNIMPL_FUNC(RtlCreateUnicodeStringFromAsciiz,   2); //=f2 new */
/*s_UNIMPL_FUNC(RtlImageRvaToSection,               3); //=z3 basen-> */
/*s_UNIMPL_FUNC(RtlImageRvaToVa,                    4); //=v4 basen-> */

// uTorrent 3.0
 rs_UNIMPL_FUNC(NtCreateProfile,        STATUS_NI, 9);
 rs_UNIMPL_FUNC(NtCreateProfileEx,      STATUS_NI, 10);
 rs_UNIMPL_FUNC(NtSetIntervalProfile,   STATUS_NI, 2);
 rs_UNIMPL_FUNC(NtStartProfile,         STATUS_NI, 1);
 rs_UNIMPL_FUNC(NtStopProfile,          STATUS_NI, 1);
 rs_UNIMPL_FUNC(NtQueryIntervalProfile, STATUS_NI, 2);

// Battlefield2
 rs_UNIMPL_FUNC(NtFsControlFile,                STATUS_NI, 10);
 rs_UNIMPL_FUNC(NtOpenKey,                      STATUS_NI, 3);
 rs_UNIMPL_FUNC(NtQueryOpenSubKeys,             STATUS_NI, 2);
 rs_UNIMPL_FUNC(NtSetValueKey,                  STATUS_NI, 6);
  s_UNIMPL_FUNC(RtlDestroyEnvironment,                     1);
 rs_UNIMPL_FUNC(RtlQueryEnvironmentVariable_U,  STATUS_NI, 3);
 rs_UNIMPL_FUNC(RtlSetEnvironmentVariable,      STATUS_NI, 3);
 rs_UNIMPL_FUNC(RtlUnicodeStringToInteger,      STATUS_NI, 3);

 // other Nt*Key
 rs_UNIMPL_FUNC(NtEnumerateValueKey,            STATUS_NI, 6);
 rs_UNIMPL_FUNC(NtQueryKey,                     STATUS_NI, 5);
 rs_UNIMPL_FUNC(NtQueryValueKey,                STATUS_NI, 6);

 rs_UNIMPL_FUNC(NtMapViewOfSection,     STATUS_NI, 10); //=n10  ;2k Gdi32
 rs_UNIMPL_FUNC(NtUnmapViewOfSection,   STATUS_NI,  2); //=n2   ;2k Gdi32
  s_UNIMPL_FUNC(RtlDosPathNameToNtPathName_U,       4); //=f4   ;ROS Gdi32

/*  s_UNIMPL_FUNC(DbgPrompt,                          3); */
 rs_UNIMPL_FUNC(RtlGetHandleValueHeap,  STATUS_NI,  2); //se:v2 ?
 rs_UNIMPL_FUNC(RtlGrowHeap,            STATUS_NI,  2); //se:v2 ?
/* rs_UNIMPL_FUNC(RtlMultiByteToUnicodeN, STATUS_NI,  5); //se:v4  new */
 rs_UNIMPL_FUNC(RtlSetHandleValueHeap,  STATUS_NI,  3); //se:v3 ?
/* rs_UNIMPL_FUNC(RtlUnicodeToMultiByteN, STATUS_NI,  5); //se:v4  new */

// potential Advapi32 redirects
 rs_UNIMPL_FUNC(RtlAddAccessDeniedAce,            STATUS_NI, 4); //cw
 rs_UNIMPL_FUNC(RtlAddAce,                        STATUS_NI, 5); //cw
 rs_UNIMPL_FUNC(RtlAddAuditAccessAce,             STATUS_NI, 6); //cw
 rs_UNIMPL_FUNC(RtlDeleteSecurityObject,          STATUS_NI, 1); //cw
 rs_UNIMPL_FUNC(RtlFirstFreeAce,                  STATUS_NI, 2); //wine sec.c
 rs_UNIMPL_FUNC(RtlNewSecurityObject,             STATUS_NI, 6); //cw
 rs_UNIMPL_FUNC(RtlQueryInformationAcl,           STATUS_NI, 4); //cw
 rs_UNIMPL_FUNC(RtlQuerySecurityObject,           STATUS_NI, 5); //cw
 rs_UNIMPL_FUNC(RtlSetControlSecurityDescriptor,  STATUS_NI, 3); //docs.rs
 rs_UNIMPL_FUNC(RtlSetInformationAcl,             STATUS_NI, 4); //cw
 rs_UNIMPL_FUNC(RtlSetSaclSecurityDescriptor,     STATUS_NI, 4); //cw
 rs_UNIMPL_FUNC(RtlSetSecurityObject,             STATUS_NI, 5); //cw
 rs_UNIMPL_FUNC(RtlValidAcl,                      STATUS_NI, 1); //cw

//RtlInterlockedCompareExchange64 5.2
//RtlIsCriticalSectionLocked 5.2
//RtlIsCriticalSectionLockedByThread 5.2
//RtlRunEncodeUnicodeString 3.10
//RtlRunDecodeUnicodeString 3.10"

 rs_UNIMPL_FUNC(RtlIsCriticalSectionLocked,         STATUS_NI, 1);
 rs_UNIMPL_FUNC(RtlIsCriticalSectionLockedByThread, STATUS_NI, 1);
